using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;

namespace takm32025_26
{
    internal class Program
    {
        static long[] NextClossest(long[] x, Dictionary<long, long> j, int n)
        {
            long[] ncj = new long[n];
            for(int i = 0; i < n; i++)
            {
                ncj[i] = -2;
            }
            Stack<long> stack = new Stack<long>();
            Stack<long> stack2 = new Stack<long>();
            for(int i = n-1; i >-1; i--)
            {
                while(stack.Count > 0 && stack.Peek() < j[x[i]])
                {
                    stack.Pop();
                    stack2.Pop();
                }
                if(stack.Count > 0)
                {
                    ncj[i] = stack2.Peek();
                }
                stack.Push(j[x[i]]);
                stack2.Push(x[i]);
            }
            return ncj;
        }
        static long[] PreviusClossest(long[] x, Dictionary<long, long> j, int n)
        {
            long[] pcj = new long[n];
            for (int i = 0; i < n; i++)
            {
                pcj[i] = -3;
            }
            Stack<long> stack = new Stack<long>();
            Stack< long> stack2 = new Stack<long>();
            for (int i = 0; i <n; i++)
            {
                while (stack.Count > 0 && stack.Peek() < j[x[i]])
                {
                    stack.Pop();
                    stack2.Pop();
                }
                if (stack.Count > 0)
                {
                    pcj[i] = stack2.Peek();
                }
                stack.Push(j[x[i]]);
                stack2.Push(x[i]);
            }
            return pcj;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            string[] inputX = Console.ReadLine().Split();
            string[] inputH = Console.ReadLine().Split();
            long[] X = new long[n];
            long[] H = new long[n];
            long[] R = new long[n];
            long[] NCJ = new long[n];
            long[] PCJ = new long[n];
            Dictionary<long, long> J = new Dictionary<long, long>();
            Dictionary<long, long> JH = new Dictionary<long, long>();
            for (int i = 0; i < n; i++)
            {
                X[i] = int.Parse(inputX[i]);
                H[i] = int.Parse(inputH[i]);
            }
            for(int i = 0; i < n; ++i)
            {
                J.Add(X[i], H[i]);
                JH.Add(X[i], i);
            }
            Array.Sort(X);
            NCJ = NextClossest(X, J, n);
            PCJ = PreviusClossest(X, J, n);

            for(int i = 0; i < n; i++)
            {
                if (NCJ[i] == -2 && PCJ[i] == -3)
                {
                    R[JH[X[i]]] = -1;
                }
                else if (PCJ[i] == -3)
                {
                    R[JH[X[i]]] = NCJ[i] - X[i] + J[X[i]] - J[NCJ[i]];
                }
                else if (NCJ[i] == -2)
                {
                    R[JH[X[i]]] = Math.Abs(X[i] - PCJ[i] + J[X[i]] - J[PCJ[i]]);
                }
                else
                {
                    long r1 = NCJ[i] - X[i] + J[X[i]] - J[NCJ[i]];
                    long r2 = Math.Abs(X[i] - PCJ[i] + J[X[i]] - J[PCJ[i]]);
                    R[JH[X[i]]] = Math.Min(r1, r2);
                }
            }
            
            for(int i = 0; i < n; i++)
            {
                Console.WriteLine(R[i]);
            }
        }
    }
}